/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.entity.threading;

import com.performant.coremod.Performant;
import com.performant.coremod.entity.threading.IThreadedMoveEntity;
import com.performant.coremod.entity.threading.MoveData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.LivingEntity;

public class MoveThread
extends Thread {
    public static volatile boolean running = true;
    private static List<MoveThread> threads = new ArrayList<MoveThread>();
    private static ConcurrentLinkedQueue<MoveData> moveQue = new ConcurrentLinkedQueue();
    private static ConcurrentLinkedQueue<LivingEntity> collQue = new ConcurrentLinkedQueue();

    public static List<MoveThread> getInstances() {
        return threads;
    }

    public MoveThread() {
        this.setDaemon(true);
        threads.add(this);
        this.start();
    }

    @Override
    public void run() {
        while (running) {
            try {
                while (!moveQue.isEmpty()) {
                    MoveData data = moveQue.poll();
                    if (data == null || data.movePos == null || data.entity == null || !data.entity.shouldRun()) continue;
                    data.entity.callTravel(data);
                }
                Thread.sleep(1L);
                while (!collQue.isEmpty()) {
                    LivingEntity entity = collQue.poll();
                    if (!(entity instanceof IThreadedMoveEntity) || !entity.func_70089_S()) continue;
                    ((IThreadedMoveEntity)entity).callEntityCollisions();
                }
                Thread.sleep(0L);
            }
            catch (Exception e) {
                Performant.LOGGER.warn("Error during entity move:", (Throwable)e);
                if (!(e instanceof InterruptedException)) continue;
                break;
            }
        }
    }

    public static void enqueMove(MoveData moveData) {
        moveQue.offer(moveData);
    }

    public static void enqueEntityColl(LivingEntity entity) {
        collQue.offer(entity);
    }
}

